﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;


namespace PI.ZB.N1200.ELearning.WinForms.EvaluationSheet
{
    public partial class UCEvaluationSheetDetails : PI.FM.N000.Base.WinForms.Controls.UCBODetails<BL.BO.EvaluationSheet, BL.BO.EvaluationSheet.Search>
    {
        private const int _IndexTabInstructor = 0;
        protected     int _IndexTabSystemInformation        = 1;
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private UCTabEvaluationSheetDetails _tabEvaluationSheetDetails = null;

        public UCTabEvaluationSheetDetails TabEvaluationSheetDetails
        {
            get
            {
                if (_tabEvaluationSheetDetails == null)
                {
                    _tabEvaluationSheetDetails = new UCTabEvaluationSheetDetails();
                }
                return _tabEvaluationSheetDetails;
            }
        }

        internal PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        protected int IndexTabSystemInformation
        {
            set
            {
                _IndexTabSystemInformation = value;
            }
            get
            {
                return _IndexTabSystemInformation;
            }
        }

        public UCEvaluationSheetDetails()
        {
            InitializeComponent();

            AddStandardControlTabs();
            MinimumHorizontalSize = 400;
            MinimumVerticalSize = 190;
        }

        protected void AddStandardControlTabs()
        {
            this.AddControlAtTab(_IndexTabInstructor, TabEvaluationSheetDetails, "Ustawienia");
            this.AddControlAtTab(_IndexTabSystemInformation     , TabSystemInformation      , "Informacje systemowe");
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment ParentEnvironment)
        {
            base.Initialize(ParentPlugIn, ParentEnvironment);

            TabEvaluationSheetDetails.Initialize(this, Environment, ParentPlugIn);
            TabSystemInformation.Initialize(this, Environment, ParentPlugIn);
        }

        protected override Gemini.Core.BL.Base.MethodResult DoSave()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            TabEvaluationSheetDetails.Save();

            _methodResult = BLZSBELearning.EvaluationSheet.Save(DataManager.Current);

            return _methodResult;
        }

        protected override bool DoRestore(long? ID)
        {
            bool _result = false;
            BL.BO.EvaluationSheet _EvaluationSheet = BLZSBELearning.EvaluationSheet.Restore(ID);
            if (_EvaluationSheet != null)
            {
                _result = true;
                DataManager.LoadData(null, null, _EvaluationSheet);
                TabEvaluationSheetDetails.Restore();
            }

            return _result;
        }

        protected override bool DoConfirmDelete()
        {
            bool _return = false;
            return _return;
        }
    }
}
